<?php
/**
 *  @author          Tassos.gr <info@tassos.gr>
 *  @link            http://www.tassos.gr
 *  @copyright       Copyright © 2018 Tassos Marinos All Rights Reserved
 *  @license         GNU GPLv3 <http://www.gnu.org/licenses/gpl.html> or later
 */

namespace NRFramework;

defined('_JEXEC') or die('Restricted access');

/**
 *  Helper class to work with country names/codes
 */
class Countries
{
    /**
     *  Return a country code from it's name
     *
     *  @param  string $country
     *  @return string|void
     */
    public static function getCode($country)
    {
        $country = \ucwords(strtolower($country));
        foreach (self::getCountriesList() as $key => $value)
        {
            if (strpos($value, $country) !== false)
            {
                return $key;
            }
        }
        return null;
    }

    /**
	 *  Countries List
	 *
	 *  @const  array
	 */
    public static  $map = [
		'AF' => "Afghanistan",
		'AX' => "Aland Islands",
		'AL' => "Albania",
		'DZ' => "Algeria",
		'AS' => "American Samoa",
		'AD' => "Andorra",
		'AO' => "Angola",
		'AI' => "Anguilla",
		'AQ' => "Antarctica",
		'AG' => "Antigua and Barbuda",
		'AR' => "Argentina",
		'AM' => "Armenia",
		'AW' => "Aruba",
		'AU' => "Australia",
		'AT' => "Austria",
		'AZ' => "Azerbaijan",
		'BS' => "Bahamas",
		'BH' => "Bahrain",
		'BD' => "Bangladesh",
		'BB' => "Barbados",
		'BY' => "Belarus",
		'BE' => "Belgium",
		'BZ' => "Belize",
		'BJ' => "Benin",
		'BM' => "Bermuda",
		'BT' => "Bhutan",
		'BO' => "Bolivia",
		'BA' => "Bosnia and Herzegovina",
		'BW' => "Botswana",
		'BV' => "Bouvet Island",
		'BR' => "Brazil",
		'IO' => "British Indian Ocean Territory",
		'BN' => "Brunei Darussalam",
		'BG' => "Bulgaria",
		'BF' => "Burkina Faso",
		'BI' => "Burundi",
		'KH' => "Cambodia",
		'CM' => "Cameroon",
		'CA' => "Canada",
		'CV' => "Cape Verde",
		'KY' => "Cayman Islands",
		'CF' => "Central African Republic",
		'TD' => "Chad",
		'CL' => "Chile",
		'CN' => "China",
		'CX' => "Christmas Island",
		'CC' => "Cocos (Keeling) Islands",
		'CO' => "Colombia",
		'KM' => "Comoros",
		'CG' => "Congo",
		'CD' => "Congo, The Democratic Republic of the",
		'CK' => "Cook Islands",
		'CR' => "Costa Rica",
		'CI' => "Cote d'Ivoire",
		'HR' => "Croatia",
		'CU' => "Cuba",
		'CY' => "Cyprus",
		'CZ' => "Czech Republic",
		'DK' => "Denmark",
		'DJ' => "Djibouti",
		'DM' => "Dominica",
		'DO' => "Dominican Republic",
		'EC' => "Ecuador",
		'EG' => "Egypt",
		'SV' => "El Salvador",
		'GQ' => "Equatorial Guinea",
		'ER' => "Eritrea",
		'EE' => "Estonia",
		'ET' => "Ethiopia",
		'FK' => "Falkland Islands (Malvinas)",
		'FO' => "Faroe Islands",
		'FJ' => "Fiji",
		'FI' => "Finland",
		'FR' => "France",
		'GF' => "French Guiana",
		'PF' => "French Polynesia",
		'TF' => "French Southern Territories",
		'GA' => "Gabon",
		'GM' => "Gambia",
		'GE' => "Georgia",
		'DE' => "Germany",
		'GH' => "Ghana",
		'GI' => "Gibraltar",
		'GR' => "Greece",
		'GL' => "Greenland",
		'GD' => "Grenada",
		'GP' => "Guadeloupe",
		'GU' => "Guam",
		'GT' => "Guatemala",
		'GG' => "Guernsey",
		'GN' => "Guinea",
		'GW' => "Guinea-Bissau",
		'GY' => "Guyana",
		'HT' => "Haiti",
		'HM' => "Heard Island and McDonald Islands",
		'VA' => "Holy See (Vatican City State)",
		'HN' => "Honduras",
		'HK' => "Hong Kong",
		'HU' => "Hungary",
		'IS' => "Iceland",
		'IN' => "India",
		'ID' => "Indonesia",
		'IR' => "Iran, Islamic Republic of",
		'IQ' => "Iraq",
		'IE' => "Ireland",
		'IM' => "Isle of Man",
		'IL' => "Israel",
		'IT' => "Italy",
		'JM' => "Jamaica",
		'JP' => "Japan",
		'JE' => "Jersey",
		'JO' => "Jordan",
		'KZ' => "Kazakhstan",
		'KE' => "Kenya",
		'KI' => "Kiribati",
		'KP' => "Korea, Democratic People's Republic of",
		'KR' => "Korea, Republic of",
		'KW' => "Kuwait",
		'KG' => "Kyrgyzstan",
		'LA' => "Lao People's Democratic Republic",
		'LV' => "Latvia",
		'LB' => "Lebanon",
		'LS' => "Lesotho",
		'LR' => "Liberia",
		'LY' => "Libyan Arab Jamahiriya",
		'LI' => "Liechtenstein",
		'LT' => "Lithuania",
		'LU' => "Luxembourg",
		'MO' => "Macao",
		'MK' => "Macedonia",
		'MG' => "Madagascar",
		'MW' => "Malawi",
		'MY' => "Malaysia",
		'MV' => "Maldives",
		'ML' => "Mali",
		'MT' => "Malta",
		'MH' => "Marshall Islands",
		'MQ' => "Martinique",
		'MR' => "Mauritania",
		'MU' => "Mauritius",
		'YT' => "Mayotte",
		'MX' => "Mexico",
		'FM' => "Micronesia, Federated States of",
		'MD' => "Moldova, Republic of",
		'MC' => "Monaco",
		'MN' => "Mongolia",
		'ME' => "Montenegro",
		'MS' => "Montserrat",
		'MA' => "Morocco",
		'MZ' => "Mozambique",
		'MM' => "Myanmar",
		'NA' => "Namibia",
		'NR' => "Nauru",
		'NP' => "Nepal",
		'NL' => "Netherlands",
		'AN' => "Netherlands Antilles",
		'NC' => "New Caledonia",
		'NZ' => "New Zealand",
		'NI' => "Nicaragua",
		'NE' => "Niger",
		'NG' => "Nigeria",
		'NU' => "Niue",
		'NF' => "Norfolk Island",
		'MP' => "Northern Mariana Islands",
		'NO' => "Norway",
		'OM' => "Oman",
		'PK' => "Pakistan",
		'PW' => "Palau",
		'PS' => "Palestinian Territory",
		'PA' => "Panama",
		'PG' => "Papua New Guinea",
		'PY' => "Paraguay",
		'PE' => "Peru",
		'PH' => "Philippines",
		'PN' => "Pitcairn",
		'PL' => "Poland",
		'PT' => "Portugal",
		'PR' => "Puerto Rico",
		'QA' => "Qatar",
		'RE' => "Reunion",
		'RO' => "Romania",
		'RU' => "Russian Federation",
		'RW' => "Rwanda",
		'SH' => "Saint Helena",
		'KN' => "Saint Kitts and Nevis",
		'LC' => "Saint Lucia",
		'PM' => "Saint Pierre and Miquelon",
		'VC' => "Saint Vincent and the Grenadines",
		'WS' => "Samoa",
		'SM' => "San Marino",
		'ST' => "Sao Tome and Principe",
		'SA' => "Saudi Arabia",
		'SN' => "Senegal",
		'RS' => "Serbia",
		'SC' => "Seychelles",
		'SL' => "Sierra Leone",
		'SG' => "Singapore",
		'SK' => "Slovakia",
		'SI' => "Slovenia",
		'SB' => "Solomon Islands",
		'SO' => "Somalia",
		'ZA' => "South Africa",
		'GS' => "South Georgia and the South Sandwich Islands",
		'ES' => "Spain",
		'LK' => "Sri Lanka",
		'SD' => "Sudan",
		'SS' => "South Sudan",
		'SR' => "Suriname",
		'SJ' => "Svalbard and Jan Mayen",
		'SZ' => "Swaziland",
		'SE' => "Sweden",
		'CH' => "Switzerland",
		'SY' => "Syrian Arab Republic",
		'TW' => "Taiwan",
		'TJ' => "Tajikistan",
		'TZ' => "Tanzania, United Republic of",
		'TH' => "Thailand",
		'TL' => "Timor-Leste",
		'TG' => "Togo",
		'TK' => "Tokelau",
		'TO' => "Tonga",
		'TT' => "Trinidad and Tobago",
		'TN' => "Tunisia",
		'TR' => "Turkey",
		'TM' => "Turkmenistan",
		'TC' => "Turks and Caicos Islands",
		'TV' => "Tuvalu",
		'UG' => "Uganda",
		'UA' => "Ukraine",
		'AE' => "United Arab Emirates",
		'GB' => "United Kingdom",
		'US' => "United States",
		'UM' => "United States Minor Outlying Islands",
		'UY' => "Uruguay",
		'UZ' => "Uzbekistan",
		'VU' => "Vanuatu",
		'VE' => "Venezuela",
		'VN' => "Vietnam",
		'VG' => "Virgin Islands, British",
		'VI' => "Virgin Islands, U.S.",
		'WF' => "Wallis and Futuna",
		'EH' => "Western Sahara",
		'YE' => "Yemen",
		'ZM' => "Zambia",
		'ZW' => "Zimbabwe",
	];
	
	/**
	 * Returns translatable countries list
	 * 
	 * @return  array
	 */
	public static function getCountriesList()
	{
		return [
			'AF' => \JText::_('NR_COUNTRY_AF'),
			'AX' => \JText::_('NR_COUNTRY_AX'),
			'AL' => \JText::_('NR_COUNTRY_AL'),
			'DZ' => \JText::_('NR_COUNTRY_DZ'),
			'AS' => \JText::_('NR_COUNTRY_AS'),
			'AD' => \JText::_('NR_COUNTRY_AD'),
			'AO' => \JText::_('NR_COUNTRY_AO'),
			'AI' => \JText::_('NR_COUNTRY_AI'),
			'AQ' => \JText::_('NR_COUNTRY_AQ'),
			'AG' => \JText::_('NR_COUNTRY_AG'),
			'AR' => \JText::_('NR_COUNTRY_AR'),
			'AM' => \JText::_('NR_COUNTRY_AM'),
			'AW' => \JText::_('NR_COUNTRY_AW'),
			'AU' => \JText::_('NR_COUNTRY_AU'),
			'AT' => \JText::_('NR_COUNTRY_AT'),
			'AZ' => \JText::_('NR_COUNTRY_AZ'),
			'BS' => \JText::_('NR_COUNTRY_BS'),
			'BH' => \JText::_('NR_COUNTRY_BH'),
			'BD' => \JText::_('NR_COUNTRY_BD'),
			'BB' => \JText::_('NR_COUNTRY_BB'),
			'BY' => \JText::_('NR_COUNTRY_BY'),
			'BE' => \JText::_('NR_COUNTRY_BE'),
			'BZ' => \JText::_('NR_COUNTRY_BZ'),
			'BJ' => \JText::_('NR_COUNTRY_BJ'),
			'BM' => \JText::_('NR_COUNTRY_BM'),
			'BT' => \JText::_('NR_COUNTRY_BT'),
			'BO' => \JText::_('NR_COUNTRY_BO'),
			'BA' => \JText::_('NR_COUNTRY_BA'),
			'BW' => \JText::_('NR_COUNTRY_BW'),
			'BV' => \JText::_('NR_COUNTRY_BV'),
			'BR' => \JText::_('NR_COUNTRY_BR'),
			'IO' => \JText::_('NR_COUNTRY_IO'),
			'BN' => \JText::_('NR_COUNTRY_BN'),
			'BG' => \JText::_('NR_COUNTRY_BG'),
			'BF' => \JText::_('NR_COUNTRY_BF'),
			'BI' => \JText::_('NR_COUNTRY_BI'),
			'KH' => \JText::_('NR_COUNTRY_KH'),
			'CM' => \JText::_('NR_COUNTRY_CM'),
			'CA' => \JText::_('NR_COUNTRY_CA'),
			'CV' => \JText::_('NR_COUNTRY_CV'),
			'KY' => \JText::_('NR_COUNTRY_KY'),
			'CF' => \JText::_('NR_COUNTRY_CF'),
			'TD' => \JText::_('NR_COUNTRY_TD'),
			'CL' => \JText::_('NR_COUNTRY_CL'),
			'CN' => \JText::_('NR_COUNTRY_CN'),
			'CX' => \JText::_('NR_COUNTRY_CX'),
			'CC' => \JText::_('NR_COUNTRY_CC'),
			'CO' => \JText::_('NR_COUNTRY_CO'),
			'KM' => \JText::_('NR_COUNTRY_KM'),
			'CG' => \JText::_('NR_COUNTRY_CG'),
			'CD' => \JText::_('NR_COUNTRY_CD'),
			'CK' => \JText::_('NR_COUNTRY_CK'),
			'CR' => \JText::_('NR_COUNTRY_CR'),
			'CI' => \JText::_('NR_COUNTRY_CI'),
			'HR' => \JText::_('NR_COUNTRY_HR'),
			'CU' => \JText::_('NR_COUNTRY_CU'),
			'CY' => \JText::_('NR_COUNTRY_CY'),
			'CZ' => \JText::_('NR_COUNTRY_CZ'),
			'DK' => \JText::_('NR_COUNTRY_DK'),
			'DJ' => \JText::_('NR_COUNTRY_DJ'),
			'DM' => \JText::_('NR_COUNTRY_DM'),
			'DO' => \JText::_('NR_COUNTRY_DO'),
			'EC' => \JText::_('NR_COUNTRY_EC'),
			'EG' => \JText::_('NR_COUNTRY_EG'),
			'SV' => \JText::_('NR_COUNTRY_SV'),
			'GQ' => \JText::_('NR_COUNTRY_GQ'),
			'ER' => \JText::_('NR_COUNTRY_ER'),
			'EE' => \JText::_('NR_COUNTRY_EE'),
			'ET' => \JText::_('NR_COUNTRY_ET'),
			'FK' => \JText::_('NR_COUNTRY_FK'),
			'FO' => \JText::_('NR_COUNTRY_FO'),
			'FJ' => \JText::_('NR_COUNTRY_FJ'),
			'FI' => \JText::_('NR_COUNTRY_FI'),
			'FR' => \JText::_('NR_COUNTRY_FR'),
			'GF' => \JText::_('NR_COUNTRY_GF'),
			'PF' => \JText::_('NR_COUNTRY_PF'),
			'TF' => \JText::_('NR_COUNTRY_TF'),
			'GA' => \JText::_('NR_COUNTRY_GA'),
			'GM' => \JText::_('NR_COUNTRY_GM'),
			'GE' => \JText::_('NR_COUNTRY_GE'),
			'DE' => \JText::_('NR_COUNTRY_DE'),
			'GH' => \JText::_('NR_COUNTRY_GH'),
			'GI' => \JText::_('NR_COUNTRY_GI'),
			'GR' => \JText::_('NR_COUNTRY_GR'),
			'GL' => \JText::_('NR_COUNTRY_GL'),
			'GD' => \JText::_('NR_COUNTRY_GD'),
			'GP' => \JText::_('NR_COUNTRY_GP'),
			'GU' => \JText::_('NR_COUNTRY_GU'),
			'GT' => \JText::_('NR_COUNTRY_GT'),
			'GG' => \JText::_('NR_COUNTRY_GG'),
			'GN' => \JText::_('NR_COUNTRY_GN'),
			'GW' => \JText::_('NR_COUNTRY_GW'),
			'GY' => \JText::_('NR_COUNTRY_GY'),
			'HT' => \JText::_('NR_COUNTRY_HT'),
			'HM' => \JText::_('NR_COUNTRY_HM'),
			'VA' => \JText::_('NR_COUNTRY_VA'),
			'HN' => \JText::_('NR_COUNTRY_HN'),
			'HK' => \JText::_('NR_COUNTRY_HK'),
			'HU' => \JText::_('NR_COUNTRY_HU'),
			'IS' => \JText::_('NR_COUNTRY_IS'),
			'IN' => \JText::_('NR_COUNTRY_IN'),
			'ID' => \JText::_('NR_COUNTRY_ID'),
			'IR' => \JText::_('NR_COUNTRY_IR'),
			'IQ' => \JText::_('NR_COUNTRY_IQ'),
			'IE' => \JText::_('NR_COUNTRY_IE'),
			'IM' => \JText::_('NR_COUNTRY_IM'),
			'IL' => \JText::_('NR_COUNTRY_IL'),
			'IT' => \JText::_('NR_COUNTRY_IT'),
			'JM' => \JText::_('NR_COUNTRY_JM'),
			'JP' => \JText::_('NR_COUNTRY_JP'),
			'JE' => \JText::_('NR_COUNTRY_JE'),
			'JO' => \JText::_('NR_COUNTRY_JO'),
			'KZ' => \JText::_('NR_COUNTRY_KZ'),
			'KE' => \JText::_('NR_COUNTRY_KE'),
			'KI' => \JText::_('NR_COUNTRY_KI'),
			'KP' => \JText::_('NR_COUNTRY_KP'),
			'KR' => \JText::_('NR_COUNTRY_KR'),
			'KW' => \JText::_('NR_COUNTRY_KW'),
			'KG' => \JText::_('NR_COUNTRY_KG'),
			'LA' => \JText::_('NR_COUNTRY_LA'),
			'LV' => \JText::_('NR_COUNTRY_LV'),
			'LB' => \JText::_('NR_COUNTRY_LB'),
			'LS' => \JText::_('NR_COUNTRY_LS'),
			'LR' => \JText::_('NR_COUNTRY_LR'),
			'LY' => \JText::_('NR_COUNTRY_LY'),
			'LI' => \JText::_('NR_COUNTRY_LI'),
			'LT' => \JText::_('NR_COUNTRY_LT'),
			'LU' => \JText::_('NR_COUNTRY_LU'),
			'MO' => \JText::_('NR_COUNTRY_MO'),
			'MK' => \JText::_('NR_COUNTRY_MK'),
			'MG' => \JText::_('NR_COUNTRY_MG'),
			'MW' => \JText::_('NR_COUNTRY_MW'),
			'MY' => \JText::_('NR_COUNTRY_MY'),
			'MV' => \JText::_('NR_COUNTRY_MV'),
			'ML' => \JText::_('NR_COUNTRY_ML'),
			'MT' => \JText::_('NR_COUNTRY_MT'),
			'MH' => \JText::_('NR_COUNTRY_MH'),
			'MQ' => \JText::_('NR_COUNTRY_MQ'),
			'MR' => \JText::_('NR_COUNTRY_MR'),
			'MU' => \JText::_('NR_COUNTRY_MU'),
			'YT' => \JText::_('NR_COUNTRY_YT'),
			'MX' => \JText::_('NR_COUNTRY_MX'),
			'FM' => \JText::_('NR_COUNTRY_FM'),
			'MD' => \JText::_('NR_COUNTRY_MD'),
			'MC' => \JText::_('NR_COUNTRY_MC'),
			'MN' => \JText::_('NR_COUNTRY_MN'),
			'ME' => \JText::_('NR_COUNTRY_ME'),
			'MS' => \JText::_('NR_COUNTRY_MS'),
			'MA' => \JText::_('NR_COUNTRY_MA'),
			'MZ' => \JText::_('NR_COUNTRY_MZ'),
			'MM' => \JText::_('NR_COUNTRY_MM'),
			'NA' => \JText::_('NR_COUNTRY_NA'),
			'NR' => \JText::_('NR_COUNTRY_NR'),
			'NP' => \JText::_('NR_COUNTRY_NP'),
			'NL' => \JText::_('NR_COUNTRY_NL'),
			'AN' => \JText::_('NR_COUNTRY_AN'),
			'NC' => \JText::_('NR_COUNTRY_NC'),
			'NZ' => \JText::_('NR_COUNTRY_NZ'),
			'NI' => \JText::_('NR_COUNTRY_NI'),
			'NE' => \JText::_('NR_COUNTRY_NE'),
			'NG' => \JText::_('NR_COUNTRY_NG'),
			'NU' => \JText::_('NR_COUNTRY_NU'),
			'NF' => \JText::_('NR_COUNTRY_NF'),
			'MP' => \JText::_('NR_COUNTRY_MP'),
			'NO' => \JText::_('NR_COUNTRY_NO'),
			'OM' => \JText::_('NR_COUNTRY_OM'),
			'PK' => \JText::_('NR_COUNTRY_PK'),
			'PW' => \JText::_('NR_COUNTRY_PW'),
			'PS' => \JText::_('NR_COUNTRY_PS'),
			'PA' => \JText::_('NR_COUNTRY_PA'),
			'PG' => \JText::_('NR_COUNTRY_PG'),
			'PY' => \JText::_('NR_COUNTRY_PY'),
			'PE' => \JText::_('NR_COUNTRY_PE'),
			'PH' => \JText::_('NR_COUNTRY_PH'),
			'PN' => \JText::_('NR_COUNTRY_PN'),
			'PL' => \JText::_('NR_COUNTRY_PL'),
			'PT' => \JText::_('NR_COUNTRY_PT'),
			'PR' => \JText::_('NR_COUNTRY_PR'),
			'QA' => \JText::_('NR_COUNTRY_QA'),
			'RE' => \JText::_('NR_COUNTRY_RE'),
			'RO' => \JText::_('NR_COUNTRY_RO'),
			'RU' => \JText::_('NR_COUNTRY_RU'),
			'RW' => \JText::_('NR_COUNTRY_RW'),
			'SH' => \JText::_('NR_COUNTRY_SH'),
			'KN' => \JText::_('NR_COUNTRY_KN'),
			'LC' => \JText::_('NR_COUNTRY_LC'),
			'PM' => \JText::_('NR_COUNTRY_PM'),
			'VC' => \JText::_('NR_COUNTRY_VC'),
			'WS' => \JText::_('NR_COUNTRY_WS'),
			'SM' => \JText::_('NR_COUNTRY_SM'),
			'ST' => \JText::_('NR_COUNTRY_ST'),
			'SA' => \JText::_('NR_COUNTRY_SA'),
			'SN' => \JText::_('NR_COUNTRY_SN'),
			'RS' => \JText::_('NR_COUNTRY_RS'),
			'SC' => \JText::_('NR_COUNTRY_SC'),
			'SL' => \JText::_('NR_COUNTRY_SL'),
			'SG' => \JText::_('NR_COUNTRY_SG'),
			'SK' => \JText::_('NR_COUNTRY_SK'),
			'SI' => \JText::_('NR_COUNTRY_SI'),
			'SB' => \JText::_('NR_COUNTRY_SB'),
			'SO' => \JText::_('NR_COUNTRY_SO'),
			'ZA' => \JText::_('NR_COUNTRY_ZA'),
			'GS' => \JText::_('NR_COUNTRY_GS'),
			'ES' => \JText::_('NR_COUNTRY_ES'),
			'LK' => \JText::_('NR_COUNTRY_LK'),
			'SD' => \JText::_('NR_COUNTRY_SD'),
			'SS' => \JText::_('NR_COUNTRY_SS'),
			'SR' => \JText::_('NR_COUNTRY_SR'),
			'SJ' => \JText::_('NR_COUNTRY_SJ'),
			'SZ' => \JText::_('NR_COUNTRY_SZ'),
			'SE' => \JText::_('NR_COUNTRY_SE'),
			'CH' => \JText::_('NR_COUNTRY_CH'),
			'SY' => \JText::_('NR_COUNTRY_SY'),
			'TW' => \JText::_('NR_COUNTRY_TW'),
			'TJ' => \JText::_('NR_COUNTRY_TJ'),
			'TZ' => \JText::_('NR_COUNTRY_TZ'),
			'TH' => \JText::_('NR_COUNTRY_TH'),
			'TL' => \JText::_('NR_COUNTRY_TL'),
			'TG' => \JText::_('NR_COUNTRY_TG'),
			'TK' => \JText::_('NR_COUNTRY_TK'),
			'TO' => \JText::_('NR_COUNTRY_TO'),
			'TT' => \JText::_('NR_COUNTRY_TT'),
			'TN' => \JText::_('NR_COUNTRY_TN'),
			'TR' => \JText::_('NR_COUNTRY_TR'),
			'TM' => \JText::_('NR_COUNTRY_TM'),
			'TC' => \JText::_('NR_COUNTRY_TC'),
			'TV' => \JText::_('NR_COUNTRY_TV'),
			'UG' => \JText::_('NR_COUNTRY_UG'),
			'UA' => \JText::_('NR_COUNTRY_UA'),
			'AE' => \JText::_('NR_COUNTRY_AE'),
			'GB' => \JText::_('NR_COUNTRY_GB'),
			'US' => \JText::_('NR_COUNTRY_US'),
			'UM' => \JText::_('NR_COUNTRY_UM'),
			'UY' => \JText::_('NR_COUNTRY_UY'),
			'UZ' => \JText::_('NR_COUNTRY_UZ'),
			'VU' => \JText::_('NR_COUNTRY_VU'),
			'VE' => \JText::_('NR_COUNTRY_VE'),
			'VN' => \JText::_('NR_COUNTRY_VN'),
			'VG' => \JText::_('NR_COUNTRY_VG'),
			'VI' => \JText::_('NR_COUNTRY_VI'),
			'WF' => \JText::_('NR_COUNTRY_WF'),
			'EH' => \JText::_('NR_COUNTRY_EH'),
			'YE' => \JText::_('NR_COUNTRY_YE'),
			'ZM' => \JText::_('NR_COUNTRY_ZM'),
			'ZW' => \JText::_('NR_COUNTRY_ZW')
		];
	}
}
